unit IWDBStdCtrlsWAP;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb, 
  {$ENDIF}
  {$IFDEF Linux}
    QControls,
  {$ELSE}
    {$IFNDEF VSNET}
    Controls,
    {$ENDIF}
  {$ENDIF}
  Classes, DB,
  IWControlWAP, IWCompCheckboxWAP, IWCompEditWAP, IWCompLabelWAP, IWCompListboxWAP,{ IWCompMemoWAP,
  {IWCompTextWAP,} IWWapTag, IWWAPRenderContext, IWBaseInterfaces;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLabelWAP.bmp}
  TIWDBLabelWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLabelWAP), 'TIWDBLabelWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBLabelWAP = class(TIWCustomLabelWAP)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    property AutoSize;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBEditWAP.bmp}
  TIWDBEditWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBEditWAP), 'TIWDBEditWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBEditWAP = class(TIWCustomEditWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property PasswordPrompt;
    property Required;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBCheckBoxWAP.bmp}
  TIWDBCheckBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBCheckBoxWAP), 'TIWDBCheckBoxWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBCheckBoxWAP = class(TIWCustomCheckBoxWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    FValueChecked: string;
    FValueUnchecked: string;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetDataField(const AValue: string);
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write SetDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property ValueChecked: string read FValueChecked write FValueChecked;
    property ValueUnchecked: string read FValueUnchecked write FValueUnchecked;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBListboxWAP.bmp}
  TIWDBListBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBListBoxWAP), 'TIWDBListboxWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBListBoxWAP = class(TIWCustomListBoxWAP, IIWInputControl)
  private
    FItemIndex: Integer;
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property Items;
    property ItemIndex: Integer read FItemIndex write FItemIndex;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBComboBoxWAP.bmp}
  TIWDBComboBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBComboBoxWAP), 'TIWDBComboBoxWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBComboBoxWAP = class(TIWCustomComboBoxWAP, IIWInputControl)
  private
    FItemIndex: Integer;
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    procedure SetValue(const AValue: string); override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property ItemIndex: Integer read FItemIndex write FItemIndex;
    property Items;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupComboBoxWAP.bmp}
  TIWDBLookupComboBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupComboBoxWAP), 'TIWDBLookupComboBoxWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBLookupComboBoxWAP = class(TIWCustomComboBoxWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    //
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupListBoxWAP.bmp}
  TIWDBLookupListBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupListBoxWAP), 'TIWDBLookupListBoxWAP.bmp'),
    TIWToolPalette('Intraweb Wap DB Controls')]
  {$ENDIF}
  TIWDBLookupListBoxWAP = class(TIWCustomListBoxWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    //
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}
  end;


(*  TIWDBMemoWAP = class(TIWCustomMemoWAP, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    procedure SetValue(const AValue: string); override;
  public
    function RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;

    property DataSource: TDataSource read FDataSource write FDataSource;
  end;

 *)


implementation

uses
  IWDBCommon,
  SysUtils,
  SWSystem;


{ TIWDBLabelWAP }
procedure TIWDBLabelWAP.InitControl;
begin
  inherited;
  Width := 80;
  Height := 20;
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBLabelWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLabelWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLabelWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLabelWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLabelWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBLabelWAP.Paint;
begin
  if Length(DataField) = 0 then begin
    Caption := Name;
  end else begin
    Caption := DataField;
  end;
  inherited Paint;
end;

destructor TIWDBLabelWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBLabelWAP.RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    // Still need this check for TDateTimeField with .DisplayText?
    if LField is TDateTimeField then begin
      Caption := FormatDateTime(TDateTimeField(LField).DisplayFormat, LField.AsDateTime);
    end else begin
      Caption := LField.DisplayText;
    end;
  end else begin
    Caption := '';
  end;
  Result := inherited RenderWAP(AContext);
end;

{ TIWDBEditWAP }

procedure TIWDBEditWAP.Paint;
begin
  Text := DataField;
  inherited Paint;
end;

{$IFDEF VSNET}
procedure TIWDBEditWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBEditWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBEditWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBEditWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBEditWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBEditWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBEditWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
//    if AutoEditable then begin
//      Editable := InEditMode(DataSource.Dataset);
//    end;
//    if Editable then begin
      if LField.DataType in [ftDate, ftTime, ftDateTime] then begin
        Text := LField.DisplayText;
      end else begin
        Text := GetFieldText(LField);
      end;
//    end else begin
//      Text := LField.DisplayText;
//    end;

    if (LField.DataType = ftString) then begin
    //TODO: Add this to base class if 3.2 supports length
//      MaxLength := LField.Size;
    end;
  end else begin
    Text := '';
  {  if AutoEditable then begin
      Editable := False;
    end;}
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBEditWAP.InitControl;
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBEditWAP.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if (GetFieldText(LField) <> Text) then begin
      FDatasource.Edit;
      LField.Text := Text;
    end;
  end;
end;

{ TIWDBCheckBoxWAP }

procedure TIWDBCheckBoxWAP.InitControl;
begin
  inherited InitControl;
  ValueChecked := 'true';
  ValueUnchecked := 'false';
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBCheckBoxWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBCheckBoxWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBCheckBoxWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBCheckBoxWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBCheckBoxWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBCheckBoxWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBCheckBoxWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FChecked := AnsiSameText(ValueChecked, GetFieldText(LField));
  end else begin
    FChecked := False;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBCheckBoxWAP.SetDataField(const AValue: string);
begin
  FDataField := AValue;
  Invalidate;
end;

procedure TIWDBCheckBoxWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    s := iif(FChecked, ValueChecked, ValueUnChecked);
    if not AnsiSameText(GetFieldText(LField), s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBListBoxWAP }

{$IFDEF VSNET}
procedure TIWDBListBoxWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBListBoxWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBListBoxWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBListBoxWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBListBoxWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBListBoxWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBListBoxWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FItemIndex := Items.IndexOf(GetFieldText(LField));
  end else begin
    FItemIndex := -1;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBListBoxWAP.InitControl;
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBListBoxWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if ItemsHaveValues then begin
          s := Values[Names[FItemIndex]];
        end
        else begin
          s := Items[FItemIndex];
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBMemoWAP }

{procedure TIWDBMemoWAP.Notification(AComponent: TComponent;
  AOperation: TOperation);
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    if FDatasource = AComponent then begin
      FDatasource := nil;
    end;
  end;
end;

function TIWDBMemoWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(DataSource, DataField, LField) then begin
    FLines.Text := GetFieldText(LField);
    FEndsWithCRLF := FLines.Text = GetFieldText(LField);
  end else begin
    FLines.Clear;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBMemoWAP.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(DataSource, DataField, LField) then begin
    // After SetValue Text holds the real value
    // When AValue does not end with CR-LF FLisnes automatically adds CRLF
    if (GetFieldText(LField) <> Text) then begin
      Datasource.Edit;
      LField.AsString := Text;
    end;
  end;
end;
 }

{ TIWDBComboBoxWAP }

{$IFDEF VSNET}
procedure TIWDBComboBoxWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBComboBoxWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBComboBoxWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBComboBoxWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBComboBoxWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBComboBoxWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBComboBoxWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FItemIndex := Items.IndexOf(GetFieldText(LField));
  end else begin
    FItemIndex := -1;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBComboBoxWAP.InitControl;
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBComboBoxWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if ItemsHaveValues then begin
          s := Values[Names[FItemIndex]];
        end
        else begin
          s := Items[FItemIndex];
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) and (s <> '') then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBLookupComboBoxWAP }


destructor TIWDBLookupComboBoxWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FKeyItems);
  inherited;
end;

procedure TIWDBLookupComboBoxWAP.InitControl;
begin
  inherited InitControl;
  FKeyItems := TStringList.Create;
  FItemIndex := -1;
  FDataField := '';
  FKeyField := '';
  FListField := '';
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBoxWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupComboBoxWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListsource.Equals(AComponent) then begin
    {$ELSE}
    if FListsource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBoxWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupComboBoxWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLookupComboBoxWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupComboBoxWAP.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupComboBoxWAP.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupComboBoxWAP.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}


function TIWDBLookupComboBoxWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
  LKeyField: TField;
begin
  Items.Clear;
  FKeyItems.Clear;
  if CheckDataSource(FListSource, ListField, LField)
   and CheckDataSource(FListSource, KeyField, LKeyField) then begin
    FListSource.DataSet.First;
    while not FListSource.Dataset.EOF do begin
      Items.Add(GetFieldText(LField));
      FKeyItems.Add(GetFieldText(LKeyField));
      FListSource.DataSet.Next;
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
  end else begin
    //FItemIndex := -1;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBLookupComboBoxWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if ItemIndex = -1 then begin
      s := #0;
    end else begin
      s := FKeyItems[ItemIndex];
    end;
    if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      if s = #0 then begin
        LField.Clear;
      end else begin
        LField.Text := s;
      end;
    end;
  end;
end;

{ TIWDBLookupListBoxWAP }

destructor TIWDBLookupListBoxWAP.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FKeyItems);
  inherited;
end;

procedure TIWDBLookupListBoxWAP.InitControl;
begin
  inherited Initcontrol;
  FKeyItems := TStringList.Create;
  FDataField := '';
  FKeyField := '';
  FListField := '';
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBoxWAP.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupListBoxWAP.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListsource.Equals(AComponent) then begin
    {$ELSE}
    if FListsource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBoxWAP.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupListBoxWAP.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLookupListBoxWAP.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupListBoxWAP.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupListBoxWAP.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupListBoxWAP.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}


function TIWDBLookupListBoxWAP.RenderWAP(
  AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LField: TField;
  LKeyField: TField;
begin
  Items.Clear;
  FKeyItems.Clear;
  if CheckDataSource(FListSource, ListField, LField)
   and CheckDataSource(FListSource, KeyField, LKeyField) then begin
    FListSource.DataSet.First;
    while not FListSource.Dataset.EOF do begin
      Items.Add(GetFieldText(LField));
      FKeyItems.Add(GetFieldText(LKeyField));
      FListSource.DataSet.Next;
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
  end else begin
    //FItemIndex := -1;
  end;
  Result := inherited RenderWAP(AContext);
end;

procedure TIWDBLookupListBoxWAP.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex = -1 then begin
      s := #0;
    end else begin
      s := FKeyItems[FItemIndex];
    end;
    if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      if s = #0 then begin
        LField.Clear;
      end else begin
        LField.Text := s;
      end;
    end;
  end;
end;

end.
